/**
  *******************************************************************************
  * 
  * @file    hal_t10.c
  * @brief   ES7P203 t10 module driver.
  *
  * @version v1.0
  * @date 22 Aug 2018
  * @author  AE Team
  * @note
  *
  * copyright (C) shanghai Eastsoft Mictroelectornics Co. Ltd. All rights reseverd.
  *
  @verbatim
  =================================================================================
  			##### How to use this driver #####
  =================================================================================
  [..]  The T10 driver can be used as follows:
    (+) Initialize the t10 registers by using t10_init().
    (+) Start t10 timer by using t10_start()
    (+) Get timer value by using t10_get_value()
    (+) Set timer value by using t10_set_value()

  @endverbatim
  *********************************************************************************
  */
#include "hal_t10.h"

/**
  * @addtogroup ES7P203_HAL
  * @{
  */

/**
  * @defgroup t10 base
  * @brief t10 module driver
  * @{
  */

/**
  * @defgroup T10_Public_Functions t10 Public Functions
  * @brief    T10 Functions
@verbatim
=================================================================================
		##### Flash Public Functions #####
=================================================================================
  [..]  The t10 driver can be used as follows:
    (+) Initialize the t10 registers by using t10_init().
    (+) Start t10 timer by using t10_start()
    (+) Get timer value by using t10_get_value()
    (+) Set timer value by using t10_set_value()
@endverbatim
  * @{
  */

/**
  * @brief  Init t10
  * @param  init: The point of init struct
  * @retval Status, see @ref hal_status_t.
  */
hal_status_t t10_init(t10_init_t *init)
{
	if (init == NULL)
		return ERROR;
	
	assert_param(IS_T10_MODE_TYPE(init->mode));
	assert_param(IS_T10_CNT_MODE_TYPE(init->cnt_mode));
	assert_param(IS_T10_PRS_TYPE(init->prs));
	
	T10EN = 0;
	
	if (init->mode == T10_COUNT_MODE) {
		PAT4  = 1;
		PAPU4 = 1;
		T10EG = init->cnt_mode;
	}
	
	T10M = init->mode;
	
	if (init->pre_func == ENABLE) {
		T10PRE = init->pre_func;
		MODIFY_REG(T10C, 0x7, init->prs);
	}
	
	return OK;
}

/**
  * @brief  Start t10
  * @param  None.
  * @retval None.
  */
void t10_start(void)
{
	T10EN = 1;
}

/**
  * @brief  Get t10 timer value
  * @param  None.
  * @retval The value
  */
uint8_t t10_get_value(void)
{
	return T10;
}

/**
  * @brief  Set t10 timer value
  * @param  data: The data set to timer
  * @retval None.
  */
void t10_set_value(uint8_t data)
{
	T10 = data;
	return;
}

/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
